#include "qhead.h"
struct qfloatstruct
  {
    QELT ar[NQ];
//    unsigned short ar[24];
  };

extern "C"
{
  void qclear (qfloatstruct *);
  void etoq (const double *, qfloatstruct *);
  void e64toq (const long double *, qfloatstruct *);
  void ltoq (long int *, qfloatstruct *);
  void asctoq (const char *, qfloatstruct *);
}

class qfloat
{
  public:
  struct qfloatstruct a;
  qfloat () {qclear(&a);};
  qfloat (double x) {etoq (&x, &a);}
  qfloat (long double x) {e64toq (&x, &a);}
  qfloat (long int x) {ltoq (&x, &a);}
// For conversion and assignment x = "1.234e4321"
  qfloat (char *x) {asctoq (x, &a);}
  friend long qtol (qfloat);
  friend float qtof (qfloat);
  friend double qtod (qfloat);
  friend long double qtold (qfloat);
};

extern "C"
{
  void qadd (const qfloat &, const qfloat &, qfloat &);
  void qsub (const qfloat &, const qfloat &, qfloat &);
  void qmul (const qfloat &, const qfloat &, qfloat &);
  void qdiv (const qfloat &, const qfloat &, qfloat &);
  void qtoasc (const qfloat *, char *, const int);
  void qtoe (const qfloat *, double *);
  void qtoe64 (const qfloat *, long double *);
  void qifrac (const qfloat *, long *, qfloat *);
  int qcmp (const qfloat &, const qfloat &);
  int mtherr (char *, int);
  void qexp (const qfloat *, qfloat *);
  void qabs (qfloat *);
  void qneg (qfloat *);
}

inline long qtol (qfloat x) {qfloat y; long l; qifrac(&x, &l, &y); return l;}

inline double qtod (qfloat x) {double d; qtoe(&x, &d); return d;}

inline long double qtold (qfloat x) {long double d; qtoe64(&x, &d); return
d;}


inline qfloat operator + (const qfloat & x, const qfloat & y)
{
  qfloat z;
  qadd (x, y, z);
  return z;
}

inline void operator += (qfloat & x, const qfloat & y)
{
  qadd (x, y, x);
}

inline qfloat operator - (const qfloat & x, const qfloat & y)
{
  qfloat z;
  qsub (y, x, z);
  return z;
}

/* Unary negation. */
inline qfloat operator - (qfloat x)
{
  qfloat z;
  z = x;
  qneg (&z);
  return z;
}

inline void operator -= (qfloat & x, const qfloat & y)
{
  qsub (y, x, x);
}

inline qfloat operator * (const qfloat & x, const qfloat & y)
{
  qfloat z;
  qmul (x, y, z);
  return z;
}

inline void operator *= (qfloat & x, const qfloat & y)
{
  qmul (y, x, x);
}

inline qfloat operator / (const qfloat & x, const qfloat & y)
{
  qfloat z;
  qdiv (y, x, z);
  return z;
}

inline void operator /= (qfloat & x, const qfloat & y)
{
  qdiv (y, x, x);
}

inline int operator == (const qfloat & x, const qfloat & y)
{
  return (qcmp (x, y) == 0);
}

inline int operator != (const qfloat & x, const qfloat & y)
{
  return (qcmp (x, y) != 0);
}

inline int operator < (const qfloat & x, const qfloat & y)
{
  return (qcmp (x, y) == -1);
}

inline int operator > (const qfloat & x, const qfloat & y)
{
  return (qcmp (x, y) == 1);
}

inline int operator >= (const qfloat & x, const qfloat & y)
{
  return (qcmp (x, y) >= 0);
}

inline int operator <= (const qfloat & x, const qfloat & y)
{
  return (qcmp (x, y) <= 0);
}

// Define other function calls analogously.
inline qfloat exp (qfloat x)
{
  qfloat y;
  qexp (&x, &y);
  return y;
}

inline qfloat abs (qfloat x)
{
  qfloat y;
  y = x;
  qabs (&y);
  return y;
}
